<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use App\Models\Permission;

class CheckPermission
{
    public function handle($request, Closure $next, $permissionId)
    {
        $user = Auth::user();

        if (!$user) {
            abort(403, '🚫 Utilisateur non authentifié');
        }

        $permission = Permission::find($permissionId);
        if (!$permission) {
            abort(404, '❌ Permission introuvable');
        }

        if (!$user->hasPermission($permission->id_perm)) {
            abort(403, '🚫 Accès refusé');
        }

        return $next($request);
    }
}
